// Ver.1.1.6 : 2023.05.31

// ＰＣとの通信路：有線（USB）の時はfalse，無線（XBee）の時はtrue，Processing側でも有線と無線を切り替える必要がある
const boolean Wireless = false;

// PIN割当
#define SS_TX   2 // ソフトウェアシリアル（送信）：ハードウェアシリアルはポート０ https://www.switch-science.com/products/1262
#define SS_RX   3 // ソフトウェアシリアル（受信）：ハードウェアシリアルはポート１
#define DO_RB1  4 //モータを接続するピン番号の定義。DOはデジタルアウトプット
#define DO_RB2  5
#define DO_LB1  6
#define DO_LB2  7
#define DO_RA1  8
#define DO_RA2  9
#define DO_LA1 10
#define DO_LA2 11
#define DO_JT1 12
#define DO_JT2 13
#define AN_JT  A1  // アナログ入力

// モーター用リレーシールドののI/O割当
#define MOTOR_RA DO_RA1
#define MOTOR_LA DO_LA1
#define MOTOR_RB DO_RB1
#define MOTOR_LB DO_LB1
#define MOTOR_JT DO_JT1

// モーター動作指示
// 0: Stop, 1: FWD, -1: BWD
char motorRA = 0; // 前方右モーター群
char motorLA = 0; // 前方左モーター群
char motorRB = 0; // 後方右モーター群
char motorLB = 0; // 後方左モーター群

// 関節関係
int J_OFF = 0; //関節補正値（起動直後の値-512を初期値とする）
#define MAX_ANGLE_DEG  (75)   // 最大回転角度（±MAX_ANGLE_DEG)
#define EASY_ANGLE_DEG (75)   // Easyモードの横移動時の関節角度（±EASY_ANGLE_DEG)
#define STEP_ANGLE_DEG (15)   // 単位回転角度（±STEP_ANGLE_DEG)
#define PT_RANGE_DEG   (280)  // ポテンショメーターの電気的回転角度（範囲）
// 以下は書き換えない
const int MAX_ANGLE_CCW  = (int)(512.0 + 1024.0 / (float)(PT_RANGE_DEG) * (float)(MAX_ANGLE_DEG));
const int MAX_ANGLE_CW   = (int)(512.0 - 1024.0 / (float)(PT_RANGE_DEG) * (float)(MAX_ANGLE_DEG));
const int EASY_ANGLE_CCW = (int)(512.0 + 1024.0 / (float)(PT_RANGE_DEG) * (float)(EASY_ANGLE_DEG));
const int EASY_ANGLE_CW  = (int)(512.0 - 1024.0 / 280.0 * (float)(EASY_ANGLE_DEG));
const int STEP_ANGLE     = (int)(1024.0 / 280.0 * (float)(STEP_ANGLE_DEG));
// ポテンショメーター RV24YN20S-B103（東京コスモス電機製）
// 機械的回転角度 300±5度，電気的回転角度280度±10度
// 1024/280 [digit/deg] と思われる（要確認）

// シリアル通信用
SoftwareSerial XBee(SS_RX, SS_TX);  // XBee用のシリアル通信ポート（ピン2, 3）
